<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\MetricaController;
use App\Http\Controllers\PeriodoController;
use App\Http\Controllers\MatriculaController;
use App\Http\Controllers\SemestreController;
use App\Http\Controllers\PlanesEstudioController;
use App\Http\Controllers\ModuloFormativoController;
use App\Http\Controllers\CursoController;
use App\Http\Controllers\PlanEstudioPeriodoController;
use App\Http\Controllers\PlanEstudioController;
use App\Http\Controllers\HorarioController;
use App\Http\Controllers\RequisitoController;
use App\Http\Controllers\TipoAdmisionController;
use App\Http\Controllers\TipoPagoController;
use App\Http\Controllers\AdmisionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\InstitutoController;
use App\Http\Controllers\DocenteController;
use App\Http\Controllers\SeccionController;
use App\Http\Controllers\TurnoController;
use App\Http\Controllers\SesionController;
use App\Http\Controllers\AsistenciaController;
use App\Http\Controllers\SilaboController;
use App\Http\Controllers\CaratulaController;
use App\Http\Controllers\LogroCursoController;
use App\Http\Controllers\SubcomponenteLogroController;
use App\Http\Controllers\NotaCursoController;
use App\Http\Controllers\PostulanteController;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\TipoContratoController;
use App\Http\Controllers\OfertaLaboralController;
use App\Http\Controllers\ArchivoCursoController;
use App\Http\Controllers\PostulacionController;
use App\Http\Controllers\Estudiante\CursosEstudianteController;
use App\Http\Controllers\AreaController;
use App\Http\Controllers\RequisitoTramiteController;
use App\Http\Controllers\TramiteController;
use App\Http\Controllers\ModuloRolController;
use App\Http\Controllers\ModuloController;
use App\Http\Controllers\SolicitudTramiteController;
use App\Http\Controllers\ConvalidacionController;
use App\Http\Controllers\PracticaProfesionalController;
use App\Http\Controllers\CertificadoController;
use App\Http\Controllers\ConceptoController;
use App\Http\Controllers\CajaController;
use App\Http\Controllers\TransaccionCajaController;
use App\Http\Controllers\AnuncioController;
use App\Http\Controllers\TareaController;
use App\Http\Controllers\PabellonController;
use App\Http\Controllers\AulaController;
use App\Http\Controllers\ResultadoAdmisionController;
use App\Http\Controllers\InscripcionController;

/* ============================================================
|  RUTAS PÚBLICAS
============================================================ */

// FORMULARIO DE POSTULACIÓN (PÚBLICO)
Route::get('/postulacion', [InscripcionController::class, 'create'])->name('postulacion.form');
Route::post('/postulacion', [InscripcionController::class, 'store'])->name('postulacion.store');



// LOGIN + REGISTER
Auth::routes();

/* ============================================================
|  DASHBOARD (REQUERIR LOGIN)
============================================================ */
Route::get('/', [MetricaController::class, 'index'])
    ->middleware('auth')
    ->name('dashboard');

/* ============================================================
|  GRUPO DE RUTAS PROTEGIDAS
============================================================ */

Route::middleware('auth')->group(function () {

    /* ==== Periodos ==== */
    Route::resource('periodos', PeriodoController::class);

    /* ==== Matrículas ==== */
    Route::post('/matriculas/nueva', [MatriculaController::class, 'nuevaMatricula'])->name('matriculas.nuevaMatricula');
    Route::get('/postulante/buscar-por-dni', [MatriculaController::class, 'buscarPorDni'])->name('postulante.buscarPorDni');
    Route::get('/cursos/por-plan-y-semestre', [MatriculaController::class, 'obtenerCursos'])->name('cursos.porPlanYSemestre');
    Route::post('/matriculas/ordinaria', [MatriculaController::class, 'registrarOrdinaria'])->name('matriculas.ordinariaMatricula');
    Route::resource('matriculas', MatriculaController::class);

    /* ==== Semestres ==== */
    Route::resource('semestres', SemestreController::class);

    /* ==== Planes de Estudio ==== */
    Route::get('/ver_malla', [PlanesEstudioController::class, 'verMalla'])->name('ver_malla');
    Route::post('/ver_malla/filtrar', [PlanesEstudioController::class, 'filtrarMalla'])->name('ver_malla.filtrar');
    Route::get('/planes-estudio/{planId}/obtener-periodos', [PlanesEstudioController::class, 'obtenerPeriodos']);
    Route::put('/planes-estudio/{planId}/asociar-periodos', [PlanesEstudioController::class, 'asociarPeriodos'])->name('planes_estudio.actualizar_periodos');
    Route::resource('planes_estudio', PlanesEstudioController::class);
    Route::get('planes-estudio/asociar', [PlanEstudioPeriodoController::class, 'index'])->name('planes_estudio.asociar_periodos');

    /* ==== Módulos Formativos ==== */
    Route::resource('modulo_formativos', ModuloFormativoController::class);
    /* ==== Inscripciones ==== */
    Route::get('/inscripciones', [InscripcionController::class, 'index'])->name('inscripciones.index');
    Route::post('/inscripciones/cambiar-estado/{id}', [InscripcionController::class, 'cambiarEstado'])->name('inscripciones.cambiarEstado');

    Route::get('/inscripciones/aceptadas', [InscripcionController::class, 'aceptadas'])->name('inscripciones.aceptadas');

    Route::get('/inscripciones/observadas', [InscripcionController::class, 'observadas'])->name('inscripciones.observadas');

    Route::get('/inscripciones/rechazadas', [InscripcionController::class, 'rechazadas'])->name('inscripciones.rechazadas');

    
    Route::get('/inscripciones/exportar/aceptados', [InscripcionController::class, 'exportarAceptados'])->name('inscripciones.exportar.aceptados');



    /* ==== Cursos ==== */
    Route::get('/modulos-por-plan/{planId}', [CursoController::class, 'modulosPorPlan']);
    Route::resource('cursos', CursoController::class);

    // Certificados — también públicos
    Route::get('/certificados/buscar', [CertificadoController::class, 'index'])->name('certificado.index');
    Route::post('/certificados/buscar', [CertificadoController::class, 'buscar'])->name('certificado.buscar');
    Route::get('/certificado/{dni}', [CertificadoController::class, 'pdf'])->name('certificado.pdf');

    /* ==== Horarios ==== */
    Route::get('/planes/por-periodo/{id}', [HorarioController::class, 'planesPorPeriodo']);
    Route::get('/cursos/por-plan/{id}', [HorarioController::class, 'cursosPorPlan']);
    Route::get('/docentes/lista', [HorarioController::class, 'obtenerDocentes'])->name('docentes.lista');
    Route::get('/horarios/por-docente-periodo/{docenteId}/{periodoId}', [HorarioController::class, 'porDocentePeriodo']);
    Route::get('/docente/horario', [HorarioController::class, 'verHorarioDocente'])->name('docente.horario');
    Route::get('/pabellones/{id}/aulas', [HorarioController::class, 'aulasPorPabellon']);
    Route::resource('horarios', HorarioController::class);

    /* ==== Requisitos ==== */
    Route::resource('requisitos', RequisitoController::class);

    /* ==== Tipo de Admisión ==== */
    Route::post('/tipo_admision/{id}/cambiar-estado', [TipoAdmisionController::class, 'cambiarEstado']);
    Route::resource('tipo_admision', TipoAdmisionController::class);

    /* ==== Tipo de Pago ==== */
    Route::post('tipo-pago/cambiar-estado', [TipoPagoController::class, 'cambiarEstado'])->name('tipo-pago.cambiar-estado');
    Route::resource('tipo-pago', TipoPagoController::class)->names('tipo-pago');

    /* ==== Admisiones ==== */
    Route::resource('admisiones', AdmisionController::class);

    /* ==== Roles ==== */
    Route::post('/roles/{id}/estado', [RoleController::class, 'cambiarEstado'])->name('roles.cambiarEstado');
    Route::resource('roles', RoleController::class);

    /* ==== Instituto ==== */
    Route::get('/instituto/provincias/{departamentoId}', [InstitutoController::class, 'obtenerProvincias'])->name('instituto.obtenerProvincias');
    Route::get('/instituto/distritos/{provinciaId}', [InstitutoController::class, 'obtenerDistritos'])->name('instituto.obtenerDistritos');
    Route::resource('instituto', InstitutoController::class);

    /* ==== Docentes ==== */
    Route::get('/docentes/{id}/roles', [DocenteController::class, 'getRoles'])->name('docentes.roles');
    Route::get('docentes/cursos/{id}/informacion', [DocenteController::class, 'informacion'])->name('docente.cursos.informacion');
    Route::get('/docente/perfil', [DocenteController::class, 'verPerfil'])->name('docente.perfil');
    Route::post('/docente/actualizar-perfil', [DocenteController::class, 'actualizarPerfil'])->name('docente.actualizar-perfil');
    Route::post('/docentes/importar', [DocenteController::class, 'importarExcel'])->name('docentes.importar');

    Route::resource('docentes', DocenteController::class);

    /* ==== Secciones ==== */
    Route::resource('secciones', SeccionController::class);

    /* ==== Turnos ==== */
    Route::resource('turnos', TurnoController::class);

    /* ==== Sesiones ==== */
    Route::get('docentes/cursos/{curso}/sesiones', [SesionController::class, 'index'])->name('docente.sesiones.index');
    Route::post('docentes/cursos/{curso}/sesiones', [SesionController::class, 'store'])->name('docente.sesiones.store');
    Route::get('docentes/sesiones/{id}/edit', [SesionController::class, 'edit'])->name('docente.sesiones.edit');
    Route::put('docentes/sesiones/{id}', [SesionController::class, 'update'])->name('docente.sesiones.update');
    Route::post('/docentes/sesiones/{id}/cambiar-estado', [SesionController::class, 'cambiarEstado']);
    Route::delete('docentes/sesiones/{id}', [SesionController::class, 'destroy'])->name('docente.sesiones.destroy');

    /* ==== Tareas ==== */
    Route::get('docentes/cursos/{curso}/tareas', [TareaController::class, 'index'])->name('docente.tareas.index');
    Route::post('docentes/cursos/{curso}/tareas', [TareaController::class, 'store'])->name('docente.tareas.store');
    Route::put('docentes/tareas/{id}', [TareaController::class, 'update'])->name('docente.tareas.update');
    Route::delete('docentes/tareas/{id}', [TareaController::class, 'destroy'])->name('docente.tareas.destroy');

    /* ==== Asistencia ==== */
    Route::get('docentes/cursos/{curso}/asistencia', [AsistenciaController::class, 'index'])->name('docente.asistencia.index');
    Route::post('docentes/cursos/{curso}/asistencia', [AsistenciaController::class, 'store'])->name('docente.asistencia.store');
    Route::get('docentes/cursos/{curso}/asistencia/pdf', [AsistenciaController::class, 'reportePdf'])->name('docente.asistencia.reporte.pdf');

    /* ==== Silabos ==== */
    Route::get('docentes/cursos/{curso}/silabos', [SilaboController::class, 'index'])->name('docente.silabos.index');
    Route::post('docentes/cursos/{curso}/silabos', [SilaboController::class, 'store'])->name('docente.silabos.store');
    Route::get('docentes/silabos/{id}/edit', [SilaboController::class, 'edit'])->name('docente.silabos.edit');
    Route::put('docentes/silabos/{id}', [SilaboController::class, 'update'])->name('docente.silabos.update');
    Route::delete('docentes/silabos/{id}', [SilaboController::class, 'destroy'])->name('docente.silabos.destroy');

    /* ==== Carátula ==== */
    Route::get('docentes/caratula/{curso_id}/pdf', [CaratulaController::class, 'pdf'])->name('docente.caratula.pdf');

    /* ==== Archivos de Cursos ==== */
    Route::get('docentes/cursos/{curso}/archivos', [ArchivoCursoController::class, 'index'])->name('docente.archivos.index');
    Route::post('docentes/cursos/{curso}/archivos', [ArchivoCursoController::class, 'store'])->name('docente.archivos.store');
    Route::put('docentes/archivos/{id}', [ArchivoCursoController::class, 'update'])->name('docente.archivos.update');
    Route::delete('docentes/archivos/{id}', [ArchivoCursoController::class, 'destroy'])->name('docente.archivos.destroy');

    /* ==== Logros ==== */
    Route::get('docentes/cursos/{curso}/logros', [LogroCursoController::class, 'index'])->name('docente.logros.index');
    Route::post('docentes/cursos/{curso}/logros', [LogroCursoController::class, 'store'])->name('docente.logros.store');
    Route::get('docentes/logros/{id}/edit', [LogroCursoController::class, 'edit'])->name('docente.logros.edit');
    Route::put('docentes/logros/{id}', [LogroCursoController::class, 'update'])->name('docente.logros.update');
    Route::delete('docentes/logros/{id}', [LogroCursoController::class, 'destroy'])->name('docente.logros.destroy');

    Route::get('docente/curso/{curso}/evaluaciones-moodle',[NotaCursoController::class, 'evaluacionesMoodle'])->name('docente.curso.evaluaciones.moodle');
    Route::get('/docente/curso/{curso}/evaluacion/{item}/notas-moodle',[NotaCursoController::class, 'notasEvaluacionMoodle'])->name('docente.curso.notas-moodle');
    Route::get(
    'docente/curso/{curso}/evaluacion/{item}/datos-modal',
    [NotaCursoController::class, 'datosModalNotasMoodle']
)->name('docente.curso.datos-modal');
Route::post(
    'docente/curso/{curso}/evaluacion/{item}/importar-notas',
    [NotaCursoController::class, 'importarNotasMoodle']
)->name('docente.curso.importar-notas');


    /* ==== Subcomponentes ==== */
    Route::get('docentes/logros/{logro}/subcomponentes', [SubcomponenteLogroController::class, 'index'])->name('docente.subcomponentes.index');
    Route::post('docentes/logros/{logro}/subcomponentes', [SubcomponenteLogroController::class, 'store'])->name('docente.subcomponentes.store');

    /* ==== Filtros docente ==== */
    Route::get('/docente/planes/{periodo_id}', [MetricaController::class, 'obtenerPlanes']);
    Route::get('/docente/semestres', [MetricaController::class, 'obtenerSemestres']);
    Route::get('/docente/cursos-filtrados', [MetricaController::class, 'filtrarCursos']);

    /* ==== Notas ==== */
    Route::get('docentes/cursos/{curso}/notas', [NotaCursoController::class, 'index'])->name('docente.notas.index');
    Route::post('/docente/curso/{curso}/notas', [NotaCursoController::class, 'store'])->name('docentes.notas.store');
    Route::get('/reporte/curso/{curso}/notas', [NotaCursoController::class, 'generarReporte'])->name('reporte.curso.notas');
    Route::get('/reporte/curso/{curso}/ranking', [NotaCursoController::class, 'generarRanking'])->name('reporte.curso.ranking');
    Route::get('/reporte/curso/{curso}/nomina', [NotaCursoController::class, 'generarNomina'])->name('reporte.curso.nomina');
    Route::get('/docente/acta-final/{id}', [NotaCursoController::class, 'actaFinal'])->name('docente.acta.final');

    /* ==== Reportes Matriculados ==== */
    Route::get('/reporte-matriculados', [MatriculaController::class, 'reporteMatriculados'])->name('reporte.matriculados');
    Route::post('/reporte-matriculados/buscar', [MatriculaController::class, 'buscarMatriculados'])->name('reporte.matriculados.buscar');
    Route::post('/reporte/matriculados/pdf', [MatriculaController::class, 'generarReportePDF'])->name('reporte.matriculados.pdf');
    Route::post('/reporte/acta-notas/pdf', [MatriculaController::class, 'generarActaNotas'])->name('reporte.acta_notas.pdf');
    Route::get('/reporte/ficha-matricula/{id}', [MatriculaController::class, 'fichaMatricula'])->name('reporte.ficha.matricula');
    Route::get('/reporte/boleta/{idPostulante}/{idSemestre}', [MatriculaController::class, 'boletaNotas'])->name('reporte.boleta');

    /* ==== ESTUDIANTES ==== */
    Route::get('estudiantes/cursos/{curso}', [CursosEstudianteController::class, 'verCurso'])->name('estudiante.cursos.ver');
    Route::get('/perfil', [PostulanteController::class, 'perfil'])->name('estudiantes.perfil');
    Route::get('/perfil/ver', [PostulanteController::class, 'verPerfil'])->name('estudiantes.perfil.ver');
    Route::get('/estudiantes/ofertas-laborales', [PostulanteController::class, 'ofertasLaborales'])->name('estudiantes.ofertas');
    Route::get('/estudiantes/ofertas-ajax', [PostulanteController::class, 'ofertasLaborales'])->name('estudiantes.ofertas.ajax');
    Route::get('/estudiantes/ofertas/modal', [PostulanteController::class, 'obtenerModalOferta'])->name('estudiantes.ofertas.modal');
    Route::get('/estudiantes/postulaciones', [PostulacionController::class, 'misPostulaciones'])->name('estudiantes.postulaciones');
    Route::put('/perfil', [PostulanteController::class, 'actualizarPerfil'])->name('estudiantes.perfil.actualizar');
    Route::post('/postulaciones', [PostulacionController::class, 'store'])->name('postulaciones.store');
    Route::delete('/postulaciones/{id}', [PostulacionController::class, 'destroy'])->name('postulaciones.destroy');
    Route::get('/estudiantes/tramites', [SolicitudTramiteController::class, 'listarTramites'])->name('estudiantes.tramites.listar');
    Route::get('/estudiantes/tramites/solicitar/{tramite}', [SolicitudTramiteController::class, 'createSolicitud'])->name('estudiantes.tramites.create');
    Route::post('/estudiantes/tramites/solicitar', [SolicitudTramiteController::class, 'storeSolicitud'])->name('estudiantes.tramites.store');
    Route::get('/estudiantes/solicitudes', [SolicitudTramiteController::class, 'indexSolicitudes'])->name('estudiantes.solicitudes.index');
    Route::get('/estudiantes/horario', [PostulanteController::class, 'verHorario'])->name('estudiantes.horario');
    Route::get('/estudiante/horario/pdf', [PostulanteController::class, 'imprimirHorario'])->name('estudiante.horario.pdf');
    Route::get('/estudiante/cursos/{id}/notas', [PostulanteController::class, 'verNotas']);
    Route::get('/estudiante/asistencia/{curso_id}', [PostulanteController::class, 'verAsistencia'])->name('estudiante.asistencia.ver');
    Route::get('/estudiantes/historial-academico', [PostulanteController::class, 'historialAcademico'])->name('estudiantes.historial');

    Route::post('/estudiantes/importar', [PostulanteController::class, 'importarExcel'])
    ->name('estudiantes.importar');


    Route::resource('estudiantes', PostulanteController::class)
        ->parameters(['estudiantes' => 'postulante']);


    Route::resource('postulantess', PostulanteController::class)
        ->parameters(['postulantess' => 'postulante']);

    /* ==== Empresas ==== */
    Route::resource('empresass', EmpresaController::class);

    /* ==== Contratos ==== */
    Route::resource('tipos-contrato', TipoContratoController::class)->names('tipos_contrato');

    /* ==== Ofertas ==== */
    Route::get('ofertas-laborales/{id}/pdf', [OfertaLaboralController::class, 'verPdf'])->name('ofertas.laborales.pdf');
    Route::get('ofertas-laborales/reporte', [OfertaLaboralController::class, 'reporteVista'])->name('ofertas.reporte');
    Route::get('ofertas-laborales/reporte/ajax', [OfertaLaboralController::class, 'reporteAjax'])->name('ofertas.reporte.ajax');
    Route::get('ofertas-laborales/{id}/postulantes', [OfertaLaboralController::class, 'verPostulantes'])->name('ofertas.verPostulantes');
    Route::get('ofertas-laborales/vencidas', [OfertaLaboralController::class, 'listarVencidas'])->name('ofertas.vencidas');
    Route::post('ofertas-laborales/reporte/vencidas', [OfertaLaboralController::class, 'reporteVencidasPdf'])->name('ofertas.reporte.vencidas');
    Route::resource('ofertas-laborales', OfertaLaboralController::class)->names('ofertas.laborales');

    /* ==== Áreas ==== */
    Route::resource('areas', AreaController::class);

    /* ==== Requisitos Tramite ==== */
    Route::resource('requisitos_tramite', RequisitoTramiteController::class);

    /* ==== Trámites ==== */
    Route::post('/tramites/derivar', [TramiteController::class, 'derivar'])->name('tramites.derivar');
    Route::post('/tramites/rechazar', [TramiteController::class, 'rechazar'])->name('tramites.rechazar');
    Route::post('/tramites/finalizar', [TramiteController::class, 'finalizar'])->name('tramites.finalizar');
    Route::get('/tramites/trazabilidad/{id}', [TramiteController::class, 'trazabilidad'])->name('tramites.trazabilidad');
    Route::get('reportes/tramites/completados', [TramiteController::class, 'completados'])->name('reportes.tramites.completados');
    Route::get('reportes/tramites/rechazados', [TramiteController::class, 'rechazados'])->name('reportes.tramites.rechazados');
    Route::get('reportes/tramites/pdf/{tipo}', [TramiteController::class, 'exportarPDF'])->name('reportes.tramites.pdf');
    Route::get('/tramites/area', [TramiteController::class, 'indexPorArea'])->name('area.tramites.index');
    Route::resource('tramitess', TramiteController::class);

    /* ==== Roles – Módulos ==== */
    Route::get('/admin/modulo-roles', [ModuloRolController::class, 'index'])->name('modulo-roles.index');
    Route::post('/admin/modulo-roles/asignar', [ModuloRolController::class, 'asignar'])->name('modulo-roles.asignar');
    Route::get('/admin/modulo-roles/{rol_id}', [ModuloRolController::class, 'getModulosPorRol']);
    Route::resource('moduloss', ModuloController::class);

    /* ==== Convalidaciones ==== */
    Route::get('/convalidaciones', [ConvalidacionController::class, 'index'])->name('convalidaciones.index');
    Route::post('/convalidaciones/buscar', [ConvalidacionController::class, 'buscarPorDni'])->name('convalidaciones.buscar');
    Route::post('/convalidaciones', [ConvalidacionController::class, 'store'])->name('convalidaciones.store');
    Route::get('/convalidaciones/listado', [ConvalidacionController::class, 'listado'])->name('convalidaciones.listado');
    Route::post('/convalidaciones/reporte', [ConvalidacionController::class, 'reporte'])->name('convalidaciones.reporte');

    /* ==== Prácticas ==== */
    Route::get('/modulos/por-postulante/{id}', [PracticaProfesionalController::class, 'modulosPorPostulante']);
    Route::resource('practicass', PracticaProfesionalController::class);

    /* ==== Conceptos ==== */
    Route::resource('conceptos', ConceptoController::class);

    /* ==== Caja ==== */
    Route::prefix('caja')->name('caja.')->group(function () {
        Route::get('/', [CajaController::class, 'index'])->name('index');
        Route::get('/apertura', [CajaController::class, 'apertura'])->name('apertura');
        Route::post('/abrir', [CajaController::class, 'abrir'])->name('abrir');
        Route::post('/cerrar/{id}', [CajaController::class, 'cerrar'])->name('cerrar');
        Route::get('/historial', [CajaController::class, 'historial'])->name('historial');
        Route::get('/detalle/{id}', [CajaController::class, 'detalle'])->name('detalle');
    });

    /* ==== Transacciones ==== */
    Route::get('/transacciones/{id}/pdf', [TransaccionCajaController::class, 'generarPdf'])->name('transacciones.pdf');
    Route::post('/transacciones/{id}/anular', [TransaccionCajaController::class, 'anular'])->name('transacciones.anular');
    Route::get('reportes/ingresos', [TransaccionCajaController::class, 'ingresos'])->name('reportes.ingresos');
    Route::post('reportes/ingresos/buscar', [TransaccionCajaController::class, 'buscarIngresos'])->name('reportes.ingresos.buscar');
    Route::post('/reportes/ingresos/pdf', [TransaccionCajaController::class, 'ingresosPdf'])->name('reportes.ingresos.pdf');
    Route::get('reportes/egresos', [TransaccionCajaController::class, 'egresos'])->name('reportes.egresos');
    Route::post('reportes/egresos/buscar', [TransaccionCajaController::class, 'buscarEgresos'])->name('reportes.egresos.buscar');
    Route::post('/reportes/egresos/pdf', [TransaccionCajaController::class, 'egresosPdf'])->name('reportes.egresos.pdf');
    Route::get('reportes/anulaciones', [TransaccionCajaController::class, 'anulaciones'])->name('reportes.anulaciones');
    Route::post('reportes/anulaciones/buscar', [TransaccionCajaController::class, 'buscarAnulaciones'])->name('reportes.anulaciones.buscar');
    Route::post('/reportes/anulaciones/pdf', [TransaccionCajaController::class, 'anulacionesPdf'])->name('reportes.anulaciones.pdf');
    Route::resource('transacciones', TransaccionCajaController::class);

    /* ==== Anuncios ==== */
    Route::resource('anuncios', AnuncioController::class);

    /* ==== Pabellones / Aulas ==== */
    Route::resource('pabellones', PabellonController::class);
    Route::resource('aulas', AulaController::class);

    Route::resource('resultados', ResultadoAdmisionController::class);

Route::get('resultados/admision/{id}', [ResultadoAdmisionController::class, 'porAdmision']);
Route::get('resultados/plan/{id}', [ResultadoAdmisionController::class, 'porPlan']);
// Importación masiva de resultados
Route::post('/resultados/importar', [ResultadoAdmisionController::class, 'importarExcel'])->name('resultados.importar');

});

/* ============================================================
|  ÚLTIMA RUTA — CATCH ALL (SOLO LOGUEADOS)
============================================================ */

Route::middleware('auth')
    ->get('/{any}', [MetricaController::class, 'index'])
    ->where('any', '.*');
