<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Asistencia</title>
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }

        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }

        .info-table {
            margin-top: 20px;
            width: 100%;
        }

        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }

        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }

        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }

        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }

        .promedio {
            font-weight: bold;
            color: #007bff;
        }

        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="{{ public_path('storage/' . $instituto->logo) }}" class="logo-img">
        <h2>Reporte de Asistencia</h2>
    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Institución</strong></td>
                <td>{{ $instituto->nombre }}</td>
                <td><strong>DRE</strong></td>
                <td>{{ $instituto->dre }}</td>
            </tr>
            <tr>
                <td><strong>Dirección</strong></td>
                <td>{{ $instituto->direccion }}</td>
                <td><strong>Teléfono</strong></td>
                <td>{{ $instituto->telefono }}</td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td>{{ $instituto->codigo_modular }}</td>
                <td><strong>Fecha de Emisión</strong></td>
                <td>{{ now()->format('d/m/Y') }}</td>
            </tr>
            <tr>
                <td><strong>Programa de Estudio</strong></td>
                <td>{{ $curso_info['programa'] }}</td>
                <td><strong>Periodo Lectivo</strong></td>
                <td>{{ $curso_info['periodo'] }}</td>
            </tr>
            <tr>
                <td><strong>Semestre Académico</strong></td>
                <td>{{ $curso_info['semestre'] }}</td>
                <td><strong>Docente</strong></td>
                <td>{{ $curso_info['docente'] }}</td>
            </tr>
        </tbody>
    </table>

    <table class="table table-bordered table-striped info-table">
        <thead>
            <tr>
                <th>N°</th>
                <th>Estudiante</th>
                <th>DNI</th>
                @foreach($sesiones as $sesion)
                    <th>{{ $loop->iteration }}</th>
                @endforeach
                <th>P</th>
                <th>F</th>
                <th>J</th>
            </tr>
        </thead>
        <tbody>
            @foreach($matriculados as $i => $mat)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td style="text-align: left;">{{ $mat->nombre }}</td>
                    <td>{{ $mat->dni }}</td>
                    @foreach($sesiones as $sesion)
                        <td>{{ $mat->asistencias_por_sesion[$sesion->id_sesion] ?? 'P' }}</td>
                    @endforeach
                    <td>{{ $mat->totalP }}</td>
                    <td>{{ $mat->totalF }}</td>
                    <td>{{ $mat->totalJ }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

</body>
</html>
